#ifndef TWI_I2C
#define TWI_I2C
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
/*	
	* Function name:
	*
	* Description:
	*
*/
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

// = = = = = = = = Structures = = = = = = = = = = =
//-------------------------
struct at24c
{
   unsigned int PageSize;   /* See below for definition */
   unsigned int NumOfPage;  /* See below for definition */
   unsigned int EepromSize;
   unsigned int SlaveAddress;
   unsigned int EepromName;
};
//------------------------

//===============================================
// = = = = = = = = Defentions = = = = = = = = = = 
#define ERROR (AT91C_TWI_NACK)
#define PIT_PIV_MICRO_SECOND_VALUE  0x2
#define PIT_PIV_MILI_SECOND_VALUE  0x667
//===============================================

// = = = = = = = = Includes = = = = = = = = = = =
// #include < lib_AT91SAM7S256.H >
// #include < AT91SAM7S256.H     >

//===============================================

 void AT91F_AT24C_WaitMiliSecond (unsigned int MiliSeconds);
 void AT91F_TWI_WaitMicroSecond (unsigned int MicroSecond);
 void AT91F_SetTwiClock(int TwiClock);
 void AT91F_TWI_Open(int TwiClock);
 int AT91F_TWI_ReadSingleIadr(const AT91PS_TWI pTwi,int SlaveAddr,int IntAddr,int IntAddrSize,char *data);
 int AT91F_TWI_WriteSingleIadr(const AT91PS_TWI pTwi,int SlaveAddr,int IntAddr,int IntAddrSize,char *data);
 int AT91F_TWI_WriteMultipleIadr(const AT91PS_TWI pTwi,int SlaveAddr,int IntAddr,int IntAddrSize,char *data,unsigned int NumOfBytes);
 int AT91F_TWI_ReadMultipleIadr(const AT91PS_TWI pTwi,int SlaveAddr,unsigned int NumOfBytes,int IntAddr,int IntAddrSize,char *data);
 char AT91F_AT24C_ReadByte (unsigned int SlaveAddress,unsigned int Address);
 void AT91F_AT24C_WriteByte (unsigned int SlaveAddress,char Data2Write,unsigned int Address);


//$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
//                                  VV Functions VV
//$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$


//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
/*	
	* Function name:  AT91F_AT24C_WaitMiliSecond
	*
	* Description:	 -
	*
*/
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
void AT91F_AT24C_WaitMiliSecond (unsigned int MiliSeconds)
{
   unsigned int PitStatus = 0;     /* Status register of the PIT */
   unsigned int PitLoop = 0;    /* Store the number of PIT Loop */

   AT91C_BASE_PITC->PITC_PIMR = AT91C_PITC_PITEN|PIT_PIV_MILI_SECOND_VALUE;

   for( PitLoop=0; PitLoop <(MiliSeconds*3);)   /* One PIT loop equals 333ms */
   {
    /* Wait for the PIT counter overflow occurs */
    while ((AT91C_BASE_PITC->PITC_PISR & AT91C_PITC_PITS)==0);
    /* Read the PIT Interval Value Reg. to clear it for the next overflow */
    PitStatus = AT91C_BASE_PITC->PITC_PIVR ;
    /* dummy access to avoid IAR warning */
    PitStatus = PitStatus ;
    PitLoop++;
   }
}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
/*	
	* Function name:   AT91F_TWI_WaitMicroSecond
	*
	* Description: -
	*
*/
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  void AT91F_TWI_WaitMicroSecond (unsigned int MicroSecond)
{
   unsigned int PitStatus = 0;     /* Status register of the PIT */
   unsigned int PitLoop = 0;    /* Store the number of PIT Loop */

   AT91C_BASE_PITC->PITC_PIMR = AT91C_PITC_PITEN|PIT_PIV_MICRO_SECOND_VALUE;

   for( PitLoop=0; PitLoop <(MicroSecond);)   /* One PIT loop equals 333ns */
   {
    /* Wait for the PIT counter overflow occurs */
    while ((AT91C_BASE_PITC->PITC_PISR & AT91C_PITC_PITS)==0);
    /* Read the PIT Interval Value Reg. to clear it for the next overflow */
    PitStatus = AT91C_BASE_PITC->PITC_PIVR ;
    /* dummy access to avoid IAR warning */
    PitStatus = PitStatus ;
    PitLoop++;
   }
}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
/*	
	* Function name:  AT91F_SetTwiClock
	*
	* Description: TWI Clock(Hz)
	*
*/
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
void AT91F_SetTwiClock(int TwiClock)
{
  unsigned int cldiv,ckdiv=1 ;

  /* CLDIV = ((Tlow x 2^CKDIV) -3) x Tmck */
  /* CHDIV = ((THigh x 2^CKDIV) -3) x Tmck */
  /* Only CLDIV is computed since CLDIV = CHDIV (50% duty cycle) */
  //AT91C_BASE_PMC->PMC_MCKR
  while ( ( cldiv = ( (18432000/(2*TwiClock))-3 ) / pow(2,ckdiv)) > 255 )
   ckdiv++ ;

  AT91C_BASE_TWI->TWI_CWGR =(ckdiv<<16)|((unsigned int)cldiv << 8)|(unsigned int)cldiv  ;
}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
/*	
	* Function name: AT91F_TWI_Open
	*
	* Description:	TwiClock(Hz)
	*
*/
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
void AT91F_TWI_Open(int TwiClock)
{
    /* Configure TWI PIOs */
    AT91F_TWI_CfgPIO ();

    /* Configure PMC by enabling TWI clock */
    AT91F_TWI_CfgPMC ();

    /* Reset the TWI */
    AT91C_BASE_TWI->TWI_CR = AT91C_TWI_SWRST;

    /* Configure TWI in master mode */
    AT91F_TWI_Configure (AT91C_BASE_TWI);

    /* Set TWI Clock Waveform Generator Register */
    AT91F_SetTwiClock(TwiClock);
}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
/*	
	* Function name: AT91F_TWI_ReadSingleIadr
	*
	* Description:	  pTwi = AT91C_BASE_TWI
	*				  IntAddrSize = (usually) 2
*/
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  int AT91F_TWI_ReadSingleIadr(const AT91PS_TWI pTwi,
                       int SlaveAddr,
                       int IntAddr,
                       int IntAddrSize,
                       char *data)
{
    unsigned int status,error=0, end=0;

    /* Enable Master Mode */
    pTwi->TWI_CR = AT91C_TWI_MSEN ;

    /* Set the TWI Master Mode Register */
    pTwi->TWI_MMR =  (SlaveAddr <<16)| (2 <<8) | AT91C_TWI_MREAD;

    /* Set TWI Internal Address Register if needed */
    pTwi->TWI_IADR = IntAddr;

    pTwi->TWI_CR = AT91C_TWI_START | AT91C_TWI_STOP;

    /* NACK errata handling */
    /* Do not poll the TWI_SR */
    /* Wait 3 x 9 TWCK pulse (max) 2 if IADRR not used, before reading TWI_SR */
    /* From 400Khz down to 1Khz, the time to wait will be in s range.*/
    /* In this example the TWI period is 1/400KHz */
    AT91F_TWI_WaitMicroSecond (40) ;

    while (!end)
    {
      status = AT91C_BASE_TWI->TWI_SR;
      if ((status & AT91C_TWI_NACK) == AT91C_TWI_NACK)
      {
        error++;
        end=1;
      }
    /*  Wait for the receive ready is set */
      if ((status & AT91C_TWI_RXRDY) == AT91C_TWI_RXRDY)
        end=1;
    }

    *(data) = pTwi->TWI_RHR;

   /* Wait for the Transmit complete is set */
   status = AT91C_BASE_TWI->TWI_SR;
   while (!(status & AT91C_TWI_TXCOMP))
     status = AT91C_BASE_TWI->TWI_SR;

    return 0;
}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
/*	
	* Function name: AT91F_TWI_WriteSingleIadr
	*
	* Description:	  pTwi = AT91C_BASE_TWI
	*				  IntAddrSize = (usually) 2
*/
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
int AT91F_TWI_WriteSingleIadr(const AT91PS_TWI pTwi,
                        int SlaveAddr,
                        int IntAddr,
                        int IntAddrSize,
                        char *data)
{
    unsigned int end = 0, status, error=0;

    /* Enable Master Mode */
    pTwi->TWI_CR = AT91C_TWI_MSEN ;

    /* Set the TWI Master Mode Register */
    pTwi->TWI_MMR =  (SlaveAddr <<16)| (2 <<8)& ((~AT91C_TWI_MREAD) );

    /* Set TWI Internal Address Register if needed */
    pTwi->TWI_IADR = IntAddr;

    /* Write the data to send into THR. Start conditionn DADDR and R/W bit
       are sent automatically */
    pTwi->TWI_THR = *data;

    /* NACK errata handling */
    /* Do not poll the TWI_SR */
    /* Wait 3 x 9 TWCK pulse (max) 2 if IADRR not used, before reading TWI_SR */
    /* From 400Khz down to 1Khz, the time to wait will be in s range.*/
    /* In this example the TWI period is 1/400KHz */
    AT91F_TWI_WaitMicroSecond (40) ;

    while (!end)
    {
      status = AT91C_BASE_TWI->TWI_SR;
      if ((status & AT91C_TWI_NACK) == AT91C_TWI_NACK)
      {
        error++;
        end=1;
      }
    /*  Wait for the Transmit ready is set */
      if ((status & AT91C_TWI_TXRDY) == AT91C_TWI_TXRDY)
        end=1;
    }

    /* Wait for the Transmit complete is set */
    status = AT91C_BASE_TWI->TWI_SR;
    while (!(status & AT91C_TWI_TXCOMP))
      status = AT91C_BASE_TWI->TWI_SR;

    return error;
}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
/*	
	* Function name:  AT91F_TWI_WriteMultipleIadr
	*
	* Description: -
	*
*/
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
int AT91F_TWI_WriteMultipleIadr(const AT91PS_TWI pTwi,
                        int SlaveAddr,
                        int IntAddr,
                        int IntAddrSize,
                        char *data,
                        unsigned int NumOfBytes)
{
    unsigned int end = 0, status, error=0, Count;

    /* Enable Master Mode */
    pTwi->TWI_CR = AT91C_TWI_MSEN ;

    /* Set the TWI Master Mode Register */
    pTwi->TWI_MMR = (SlaveAddr <<16)| (2 <<8) & ~AT91C_TWI_MREAD;

    /* Set TWI Internal Address Register if needed */
    pTwi->TWI_IADR = IntAddr;

   /* Wait until TXRDY is high to transmit */
   status = AT91C_BASE_TWI->TWI_SR;
   while (!(status & AT91C_TWI_TXRDY))
        status = AT91C_BASE_TWI->TWI_SR;

   /* Send the data */
   for ( Count=0; Count < NumOfBytes ;Count++ )
   {
       /* Write the data to send into THR. Start conditionn DADDR and R/W bit
       are sent automatically */
       AT91C_BASE_TWI->TWI_THR = *data++;

       /* NACK errata handling */
       /* Do not poll the TWI_SR */
       /* Wait 3 x 9 TWCK pulse (max) before reading TWI_SR */
       /* From 400Khz down to 1Khz, the time to wait will be in s range.*/
       /* In this example the TWI period is 1/400KHz */
       AT91F_TWI_WaitMicroSecond (40) ;

       while (!end)
       {
           status = AT91C_BASE_TWI->TWI_SR;
           if ((status & AT91C_TWI_NACK) == AT91C_TWI_NACK)
           {
               error++;
               end=1;
           }

           /*  Wait for the Transmit ready is set */
           if ((status & AT91C_TWI_TXRDY) == AT91C_TWI_TXRDY)
            end=1;
        }
    }

    /* Wait for the Transmit complete is set */
    status = AT91C_BASE_TWI->TWI_SR;
    while (!(status & AT91C_TWI_TXCOMP))
      status = AT91C_BASE_TWI->TWI_SR;

    return error;
}


//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
/*	
	* Function name:   AT91F_TWI_ReadMultipleIadr
	*
	* Description:		-
	*
*/
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
int AT91F_TWI_ReadMultipleIadr(const AT91PS_TWI pTwi,
                       int SlaveAddr,
                       unsigned int NumOfBytes,
                       int IntAddr,
                       int IntAddrSize,
                       char *data)
{
    unsigned int status,error=0, ReadCount, end=0;

   /* Enable Master Mode of the TWI */
   AT91C_BASE_TWI->TWI_CR = AT91C_TWI_MSEN ;


   /* Set the TWI Master Mode Register */
   pTwi->TWI_MMR =  (SlaveAddr <<16)| (2 <<8) | AT91C_TWI_MREAD;

   /* Set TWI Internal Address Register if needed */
   pTwi->TWI_IADR = IntAddr;

   /* Send the Start + slave address */
   AT91C_BASE_TWI->TWI_CR = AT91C_TWI_START;

   /* Read and store it into the buffer */
   for ( ReadCount=0; ReadCount <NumOfBytes; ReadCount++ )
   {
    /* if next-lo-last data send the stop */
    if (ReadCount == (NumOfBytes -1) )
      AT91C_BASE_TWI->TWI_CR = AT91C_TWI_STOP;

    /* NACK errata handling */
    /* Do not poll the TWI_SR */
    /* Wait 3 x 9 TWCK pulse (max) 2 if IADRR not used, before reading TWI_SR */
    /* From 400Khz down to 1Khz, the time to wait will be in s range.*/
    /* In this example the TWI period is 1/400KHz */
    AT91F_TWI_WaitMicroSecond (40) ;

    while (!end)
    {
      status = AT91C_BASE_TWI->TWI_SR;
      if ((status & AT91C_TWI_NACK) == AT91C_TWI_NACK)
      {
        error++;
        end=1;
      }
      /* Wait until RXRDY is high to read the next data */
      if ((status & AT91C_TWI_RXRDY) == AT91C_TWI_RXRDY)
        end=1;
    }
    /*  Read the char received */
    *data = AT91C_BASE_TWI->TWI_RHR;
    data++;
   }

   /* Wait for the Transmit complete is set */
   status = AT91C_BASE_TWI->TWI_SR;
   while (!(status & AT91C_TWI_TXCOMP))
     status = AT91C_BASE_TWI->TWI_SR;

   return 0;
}
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
/*	
	* Function name:  AT91F_AT24C_ReadByte
	*
	* Description:	struct at24c ptAt24c1024	
	*				at24c = &ptAt24c1024	  
	*
*/
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 char AT91F_AT24C_ReadByte (unsigned int SlaveAddress,
                           unsigned int Address)
{
  unsigned int WordAddress;
  
  char Data2Read ;

  /* 17th bit of the word address. Applicable to the AT24C1024 only */
  unsigned char p0=0;



   
    WordAddress = Address ;


  AT91F_TWI_ReadSingleIadr(AT91C_BASE_TWI,
                      SlaveAddress,
                      WordAddress,
                      2,
                      &Data2Read);

  return (Data2Read);


}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
/*	
	* Function name:  AT91F_AT24C_WriteByte
	*
	* Description:	struct at24c ptAt24c1024	
	*				at24c = &ptAt24c1024	  
	*
*/
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
void AT91F_AT24C_WriteByte (unsigned int SlaveAddress,
                            char Data2Write,
                            unsigned int Address)
{
  unsigned int WordAddress;
 // unsigned int SlaveAddress;

  /* 17th bit of the word address. Applicable to the AT24C1024 only */
  unsigned char p0=0;

   // SlaveAddress = ptAt24c->SlaveAddress ;
    WordAddress = Address ;


  AT91F_TWI_WriteSingleIadr(AT91C_BASE_TWI,
                      SlaveAddress,
                      WordAddress,
                      2,
                      &Data2Write);

   /* Wait 10ms before sending another start.
    See Twr time spec. in the datasheet */
    AT91F_AT24C_WaitMiliSecond (10);


}

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

#endif
