<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<title>Untitled Document</title>
		<script type="text/javascript" src="jalaliDate.js" ></script>
		<script type="text/javascript" >
			function viewData(form){
				//test function to view the calculated time stamps.
				var ts = document.getElementById( 'PersCal01_TIMESTAMP' ) ;
				if( null != ts ) {
					ts.type = 'text' ;
				}
				ts = document.getElementById( 'PersCal02_TIMESTAMP' ) ;
				if( null != ts ) {
					ts.type = 'text' ;
				}
			}
			function sendData(form){
				//test function to submit data.
				form.submit();
			}
		</script>
	</head>
	<body>
		<div style="color:darkred;font-style:oblique">
			<h1>How to use</h1>
			<p>First include the <strong>jalaliDate.js</strong> in header:</p>
			<code>&lt;script type="text/javascript" src="jalaliDate.js" &gt;&lt;/script&gt;</code>
			<p>Next create the form in the body and put at least these elements:</p>
			<code>
				&lt;form action="" method="post" &gt;<br />
					&nbsp;&lt;input type="text" name="as_you_wish" id="as_you_wish" onchange="$persianCalendar.$_manualInput(this)" /&gt;<br />
					&nbsp;&lt;input type="button" name="btnPick" id="btnPick" onclick="$persianCalendar.$openCalendar('as_you_wish', this);" value="Pick Date" /&gt;<br />
					&nbsp;&lt;input type="submit" name="btnSubmit" id="btnSubmit" value="Check with Server" /&gt;<br />
				&lt;/form&gt;
			</code>
			<p>Class name is <strong>$persianCalendar</strong> and prefixes all the methods. All methods begin with <strong>$</strong>.</p>
			<p>
				OnChange event for the input helps to monitor manual addition of date, instead of clicking the pick button. 
				The argument always is <code>this</code>. You can use <code>readonly="readonly"</code> to force using the button.
			</p>
			<p>Note: first argument for the $persianCalendar.$openCalendar function is id of the input element and the second argument always is <code>this</code>.</p>
			<p>If the user manually types a date and then selects the `Pick` button, the valid date is converted to full format `<strong>YYYY/MM/DD</strong>`.
			Non-valid date is deleted.<br />
			Valid formats are of type <strong>year/month/day</strong>. Year is either 2 or 4 digits, which supposed to be valid Jalali years.
			Month is 1 to 12 with or without the leading zero.
			Day is 1 to 31 (depending on the month) with or without leading zero.</p>
		</div>
		<div style="float:left;width:48%;text-align:center;color:darkblue;font-size:75%">
			<h3>Example</h3>
			<form action="" method="post">
				<p>This date picker utilizes the `$_manualInput` method, hence user can type valid dates.
					<input type="text" name="PersCal01" id="PersCal01" onchange="$persianCalendar.$_manualInput(this)" />
					<input type="button" name="btnPick01" id="btnPick01" onclick="$persianCalendar.$openCalendar('PersCal01', this);" value="Pick" />
				</p>
				<p>This date picker prohibits manual changing of date value, hence forces use of the button.
					<input type="text" name="PersCal02" id="PersCal02" readonly="readonly" />
					<input type="button" name="btnPick02" id="btnPick02" onclick="$persianCalendar.$openCalendar('PersCal02', this);" value="Pick" />
				</p>
				<p>Click to show the element containing the time stamp for each valid date entered.
					<input type="button" name="btnSubmit" id="btnSubmit" onclick="viewData(this.form)" value="View the time stamp values" />
				</p>
				<p>
					<input type="button" name="btnSubmit" id="btnSubmit" onclick="sendData(this.form)" value="Check with Server" />
					This part requires JalaliDate.Class.php!
				</p>
			</form>
		</div>
		<div style="float:right;width:48%;color:darkgreen;font-size:75%">
<?php
	if( ! empty( $_POST ) ) {
		require_once 'JalaliDate.Class.php';
		$select_1 = $_POST['PersCal01_TIMESTAMP'];
		$element_1 = $_POST['PersCal01'];
		$select_2 = $_POST['PersCal02_TIMESTAMP'];
		$element_2 = $_POST['PersCal02'];
		echo '<h3>' . 'PersCal01' . '</h3>' ;
		echo 'Selected date from the client --javascript: ' . $element_1 . '<br/>';
		echo 'Selected time stamp from the client --javascript: ' . $select_1 . '<br/>';
		echo 'This is equal to Persian date of: ' . JalaliDate::date('l S F Y T',$select_1 ) . '<br/>';
		echo 'And equal to Julian date of: ' . date('l dS F Y T',$select_1 ) . '<br/>';

		echo '<h3>' . 'PersCal02' . '</h3>' ;
		echo 'Selected date from the client --javascript: ' . $element_2 . '<br/>';
		echo 'Selected time stamp from the client --javascript: ' . $select_2 . '<br/>';
		echo 'This is equal to Persian date of: ' . JalaliDate::date('l S F Y T',$select_2 ) . '<br/>';
		echo 'And equal to Julian date of: ' . date('l dS F Y T',$select_2 ) . '<br/>';
	}
?>
		</div>
	</body>
</html>
