<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html>
	<head>
		<meta http-equiv='Content-Language' content='fa' />
		<meta name="AUTHOR" content="keyhansedaghat@netscape.net" />
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<meta name="KEYWORDS" content="Persian Jalali Date" />
		<title>Sample Usage of Persian Jalali Date Functions</title>
	</head>
	<body>
		<h3>Warning: This class depends on default time zone of the system.</h3>
		<h3>Specially for times other than current time.</h3>
		<pre>
		<h3>Current time zone is:
<?php
	date_default_timezone_set("Asia/Tehran");
	echo date_default_timezone_get();
?>
		</h3>
<?php
	require_once 'JalaliDate.Class.php';

// -- Build a date object from known values:
	echo "<hr />";
	echo "<h1>Persian new year (Nourooz):</h1>";
	echo "<div style=\"color:blue;float:left;\">";
	echo '<p>Build an arbitrary date using the mktime function:<br/>' ;
	echo '     $timestamp = JalaliDate::mktime(1390, 1, 1, 2, 50, 45);</p>' ;
	echo '<p>Next use date functions (from php and JalaliDate) to format output:<br/>' ;
	echo '     JalaliDate::date("l S F Y H:i:s T", $timestamp);<br/>' ;
	echo '     date("l S F Y H:i:s T", $timestamp);</p>' ;
	echo '</div>';
	$timestamp = JalaliDate::mktime(1390, 1, 1, 2, 50, 45);
	echo "<div style=\"color:red;float:right;\">";
	echo "\nTimestamp: " . $timestamp;
	echo "\nPersian calendar: " .  JalaliDate::date('l S F Y H:i:s T', $timestamp);
	echo "\nJulian calendar: " . date('l dS F Y H:i:s T', $timestamp);
	echo '</div>';
	echo '<div style="clear:both;"></div>';

// -- Build date object from system time:
	echo "<h3>Using instance of the object (do you really need to do this?!):</h3>";
	echo "<div style=\"color:blue;float:left;\">";
	echo '<p>Now instantiate from the class:<br/>' ;
	echo '     $jalali = new JalaliDate(1390, 1, 1, 2, 50, 45);</p>' ;
	echo '<p>Get the object timestamp:<br/>' ;
	echo '     $jalali->timestamp();</p>' ;
	echo '<p>Next use the same functions as above (from php and JalaliDate) to format output:<br/>' ;
	echo '     $jalali->date("l S F Y H:i:s T");<br/>' ;
	echo '     date("l S F Y H:i:s T", $jalali->timestamp);</p>' ;
	echo '</div>';
	$jalali = new JalaliDate(1390, 1, 1, 2, 50, 45);
	echo "<div style=\"color:red;float:right;\">";
	echo "\nTimestamp: " . $jalali->timestamp();
	echo "\nPersian calendar: " .  $jalali->date('l S F Y H:i:s T');
	echo "\nJulian calendar: " . date('l dS F Y H:i:s T', $jalali->timestamp());
	echo '</div>';
	echo '<div style="clear:both;"></div>';

// -- Build date object from system time:
	echo "<hr />";
	echo "<h1>Now:</h1>";
	echo "<div style=\"color:blue;float:left;\">";
	echo '<p>Use php time function to get time stamp:<br/>' ;
	echo '     $timestamp = time();</p>' ;
	echo '<p>Next use the same functions as above (from php and JalaliDate) to format output:<br/>' ;
	echo '     JalaliDate::date("l S F Y H:i:s T", $timestamp);<br/>' ;
	echo '     date("l S F Y H:i:s T", $timestamp);</p>' ;
	echo '</div>';
	$timestamp = time();
	echo "<div style=\"color:red;float:right;\">";
	echo "\nTimestamp: " . $timestamp;
	echo "\nPersian calendar: " .  JalaliDate::date('l S F Y H:i:s T', $timestamp);
	echo "\nJulian calendar: " . date('l dS F Y H:i:s T', $timestamp);
	echo '</div>';
	echo '<div style="clear:both;"></div>';

// -- Build date object from system time:
	echo "<h3>Using instance of the object (do you really need to do this?!):</h3>";
	echo "<div style=\"color:blue;float:left;\">";
	echo '<p>Now instantiate from the class:<br/>' ;
	echo '     $jalali = new JalaliDate();</p>' ;
	echo '<p>Get the object timestamp:<br/>' ;
	echo '     $jalali->timestamp();</p>' ;
	echo '<p>Next use the same functions as above (from php and JalaliDate) to format output:<br/>' ;
	echo '     $jalali->date("l S F Y H:i:s T");<br/>' ;
	echo '     date("l S F Y H:i:s T", $jalali->timestamp);</p>' ;
	echo '</div>';
	$jalali = new JalaliDate();
	echo "<div style=\"color:red;float:right;\">";
	echo "\nTimestamp: " . $jalali->timestamp();
	echo "\nPersian calendar: " .  $jalali->date('l S F Y H:i:s T');
	echo "\nJulian calendar: " . date('l dS F Y H:i:s T', $jalali->timestamp());
	echo '</div>';
	echo '<div style="clear:both;"></div>';
?>
		<hr />
		</pre>
	</body>
</html>